{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 07.01.99 - 10:13:48 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, MMWave, MMObj, MMUtils, MMWheel, Mask, ExtCtrls, MMVolume, MMConect,
  MMRingBf, MMWMixer, MMDSPObj, MMWavOut, MMHTimer, MMDesign, MMDIBCv,
  MMLevel, MMCstDlg, MMDSPMtr, MMLEDS, MMACMCvt, MMHook, MMAudio, MMSlider;
  
type
  TMainForm = class(TForm)
    MMDesigner1: TMMDesigner;
    Timer: TMMHiTimer;
    btnStop: TButton;
    btnStart: TButton;
    WaveOut: TMMWaveOut;
    WaveMixer: TMMWaveMixer;
    TimeLabel: TLabel;
    RingBuffer: TMMRingBuffer;
    Level1: TMMLevel;
    Connector: TMMConnector;
    Level2: TMMLevel;
    ckbLevel: TCheckBox;
    Label2: TLabel;
    lblDropOuts: TLabel;
    Panel1: TPanel;
    Volume1: TMMWheel;
    Label5: TLabel;
    Label6: TLabel;
    Panning1: TMMWheel;
    Label7: TLabel;
    VolumeMaster: TMMWheel;
    Label8: TLabel;
    PanningMaster: TMMWheel;
    Panel2: TPanel;
    Label11: TLabel;
    Label12: TLabel;
    Volume2: TMMWheel;
    Panning2: TMMWheel;
    Panel3: TPanel;
    Label15: TLabel;
    Label16: TLabel;
    Volume3: TMMWheel;
    Panning3: TMMWheel;
    Panel4: TPanel;
    Label19: TLabel;
    Label20: TLabel;
    Volume4: TMMWheel;
    Panning4: TMMWheel;
    MasterVolume: TMMVolume;
    ckbLoop1: TCheckBox;
    ckbLoop2: TCheckBox;
    ckbLoop3: TCheckBox;
    ckbLoop4: TCheckBox;
    FilePanel1: TPanel;
    btnFile1: TButton;
    FName1: TLabel;
    Label3: TLabel;
    meStart1: TMaskEdit;
    FilePanel2: TPanel;
    btnFile2: TButton;
    FName2: TLabel;
    Label9: TLabel;
    meStart2: TMaskEdit;
    FilePanel3: TPanel;
    btnFile3: TButton;
    FName3: TLabel;
    Label13: TLabel;
    meStart3: TMaskEdit;
    FilePanel4: TPanel;
    btnFile4: TButton;
    FName4: TLabel;
    Label17: TLabel;
    meStart4: TMaskEdit;
    Label1: TLabel;
    DSPLabel: TLabel;
    LED1: TMMLED;
    LED2: TMMLED;
    LED3: TMMLED;
    LED4: TMMLED;
    Label4: TLabel;
    lblPos4: TLabel;
    Label10: TLabel;
    lblPos3: TLabel;
    Label18: TLabel;
    lblPos2: TLabel;
    Label22: TLabel;
    lblPos1: TLabel;
    DSPMeter: TMMDSPMeter;
    btnReset1: TButton;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    AudioFile1: TMMAudioFile;
    AudioFile2: TMMAudioFile;
    AudioFile3: TMMAudioFile;
    AudioFile4: TMMAudioFile;
    OpenDialog: TOpenDialog;
    btnRestart: TButton;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTimer(Sender: TObject);
    procedure btnFileClick(Sender: TObject);
    procedure ckbLevelClick(Sender: TObject);
    procedure RingBufferEmpty(Sender: TObject);
    procedure VolumeChange(Sender: TObject);
    procedure PanningChange(Sender: TObject);
    procedure VolumeMasterChange(Sender: TObject);
    procedure PanningMasterChange(Sender: TObject);
    procedure ckbLoopClick(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure btnReset1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnRestartClick(Sender: TObject);
  private
    DropOuts   : Longint;
    TimeCounter: Longint;
    PlayStart  : Longint;
  public
    procedure UpdateFileLabel(Tag: integer);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Timer.Enabled := False;
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStart(Sender: TObject);
begin
   TimeCounter := 0;
   Timer.Enabled := True;

   btnFile1.Enabled := False;
   btnFile2.Enabled := False;
   btnFile3.Enabled := False;
   btnFile4.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStop(Sender: TObject);
begin
   Timer.Enabled := False;
   DSPLabel.Caption := '0 %';
   LED1.Enabled := False;
   LED2.Enabled := False;
   LED3.Enabled := False;
   LED4.Enabled := False;

   btnFile1.Enabled := True;
   btnFile2.Enabled := True;
   btnFile3.Enabled := True;
   btnFile4.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
var
   SPos: Longint;
begin
   DropOuts := 0;

   PlayStart := 0;
   WaveMixer.StartPos1 := MaskToTime(meStart1.Text);
   WaveMixer.StartPos2 := MaskToTime(meStart2.Text);
   WaveMixer.StartPos3 := MaskToTime(meStart3.Text);
   WaveMixer.StartPos4 := MaskToTime(meStart4.Text);


   WaveOut.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TimerTimer(Sender: TObject);
var
   Pos: Longint;
begin
   Pos := PlayStart+WaveOut.Position;
   TimeLabel.Caption  := TimeToString(Pos);

   inc(TimeCounter);
   if (Timer.Interval*TimeCounter >= 500) then
   begin
      TimeCounter := 0;
      DSPLabel.Caption := IntToStr(DSPMeter.Value)+' %';

      LED1.Enabled := WaveMixer.InputLoading[0];
      LED2.Enabled := WaveMixer.InputLoading[1];
      LED3.Enabled := WaveMixer.InputLoading[2];
      LED4.Enabled := WaveMixer.InputLoading[3];

      lblPos1.Caption := TimeToString64Ex(WaveMixer.InputPosition[0],True);
      lblPos2.Caption := TimeToString64Ex(WaveMixer.InputPosition[1],True);
      lblPos3.Caption := TimeToString64Ex(WaveMixer.InputPosition[2],True);
      lblPos4.Caption := TimeToString64Ex(WaveMixer.InputPosition[3],True);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.RingBufferEmpty(Sender: TObject);
begin
   inc(DropOuts);
   lblDropOuts.Caption := IntToStr(DropOuts);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ckbLevelClick(Sender: TObject);
begin
   Connector.Enabled := ckbLevel.Checked;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.UpdateFileLabel(Tag: integer);
begin
   case Tag of
      0: FName1.Caption := MinimizeName(AudioFile1.FileName,FName1.Canvas,FName1.Width);
      1: FName2.Caption := MinimizeName(AudioFile2.FileName,FName2.Canvas,FName2.Width);
      2: FName3.Caption := MinimizeName(AudioFile3.FileName,FName3.Canvas,FName3.Width);
      3: FName4.Caption := MinimizeName(AudioFile4.FileName,FName4.Canvas,FName4.Width);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnFileClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      case TControl(Sender).Tag of
         0: begin
               { mark this channel as done }
               WaveMixer.InputDone[0] := True;
               { set the new filename }
               AudioFile1.FileName    := OpenDialog.FileName;
               { The WaveMixer should play the channel immediately }
               { if the Input has changed }
               WaveMixer.InputDone[0] := False;
            end;
         1: begin
               WaveMixer.InputDone[1] := True;
               AudioFile2.FileName    := OpenDialog.FileName;
               WaveMixer.InputDone[1] := False;
            end;
         2: begin
               WaveMixer.InputDone[2] := True;
               AudioFile3.FileName    := OpenDialog.FileName;
               WaveMixer.InputDone[2] := False;
            end;
         3: begin
               WaveMixer.InputDone[3] := True;
               AudioFile4.FileName    := OpenDialog.FileName;
               WaveMixer.InputDone[3] := False;
            end;
      end;
      UpdateFileLabel(TControl(Sender).Tag);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnReset1Click(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: begin
            { mark this channel as done }
            WaveMixer.InputDone[0] := True;
            { set the new filename }
            AudioFile1.FileName := '';
         end;
      1: begin
            WaveMixer.InputDone[1] := True;
            AudioFile2.FileName := '';
         end;
      2: begin
            WaveMixer.InputDone[2] := True;
            AudioFile3.FileName := '';
         end;
      3: begin
            WaveMixer.InputDone[3] := True;
            AudioFile4.FileName := '';
         end;
   end;
   UpdateFileLabel(TControl(Sender).Tag);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.VolumeChange(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: AudioFile1.Volume := Volume1.Value;
      1: AudioFile2.Volume := Volume2.Value;
      2: AudioFile3.Volume := Volume3.Value;
      3: AudioFile4.Volume := Volume4.Value;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PanningChange(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: AudioFile1.Panning := Panning1.Value;
      1: AudioFile2.Panning := Panning2.Value;
      2: AudioFile3.Panning := Panning3.Value;
      3: AudioFile4.Panning := Panning4.Value;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.VolumeMasterChange(Sender: TObject);
begin
   MasterVolume.Volume := VolumeMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PanningMasterChange(Sender: TObject);
begin
   MasterVolume.Panning := PanningMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ckbLoopClick(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: WaveMixer.Loop1 := ckbLoop1.Checked;
       1: WaveMixer.Loop2 := ckbLoop2.Checked;
       2: WaveMixer.Loop3 := ckbLoop3.Checked;
       3: WaveMixer.Loop4 := ckbLoop4.Checked;
   end;
end;

procedure TMainForm.btnRestartClick(Sender: TObject);
begin
   if (wosPlay in WaveOut.State) then
   begin
      WaveOut.Pause;

      WaveOut.Reset;

      AudioFile1.Position := 0;
      AudioFile2.Position := 0;
      AudioFile3.Position := 0;
      AudioFile4.Position := 0;

      WaveMixer.StartPos1 := MaskToTime(meStart1.Text);
      WaveMixer.StartPos2 := MaskToTime(meStart2.Text);
      WaveMixer.StartPos3 := MaskToTime(meStart3.Text);
      WaveMixer.StartPos4 := MaskToTime(meStart4.Text);

      WaveOut.Restart;
   end;
end;

end.
